<report title="D2D - EMR DQ CHF Coded Denom v1" description="Lists patients with possible CHF diagnosis."
active="1">
<query>

SELECT DISTINCT d.demographic_no Demographic, d.sex Sex, floor(datediff(curdate(),str_to_date(concat(d.year_of_birth,d.month_of_birth,d.date_of_birth),'%Y%m%d'))/365.25) Age, 
                concat(d.last_name, ', ', d.first_name) Patient, concat(p.last_name, ', ', p.first_name) MRP, dx.dxresearch_code as DxCode, bi.service_code as Billing_Code, DxCode.c as Num_Dx_428
FROM (demographic d, provider p, dxresearch dx, billing_on_item bi, billing_on_cheader1 bch)
LEFT JOIN (
    SELECT d.demographic_no, COUNT(*) as c
    FROM billing_on_item bi, billing_on_cheader1 bch, demographic d
    WHERE (bi.dx = '428' OR bi.dx1 = '428' OR bi.dx2 = '428')
    AND bch.demographic_no = d.demographic_no
    AND bch.id = bi.ch1_id
    GROUP BY d.demographic_no) as DxCode
    ON d.demographic_no = DxCode.demographic_no
WHERE d.patient_status = 'AC'
AND floor(datediff(curdate(),str_to_date(concat(d.year_of_birth,d.month_of_birth,d.date_of_birth),'%Y%m%d'))/365.25) >= 38
AND d.provider_no = p.provider_no
AND bch.demographic_no = d.demographic_no
AND bch.id = bi.ch1_id  
AND (
    (dx.dxresearch_code = '428'AND d.demographic_no = dx.demographic_no)
    OR
    bi.service_code = 'Q050A'
    OR DxCode.c >= 3
    )
GROUP BY Demographic
ORDER by Demographic;

</query>

</report>